#include "StdAfx.h"

#include "TidyProxy.h"
#include "ConfigDlg.h"
#include "ConfigPage.h"
#include "Profile.h"

//-------------------------------------------------------------------
CConfigDlg::CConfigDlg(CTidyProxy* ptp) : m_pTidyProxy(ptp)
{
	// Initialize configuration categories information
	ConfPageInfo cci;
	cci.pConfigPage = NULL;
	cci.name = "Markup";
	m_ConfPageInfo.push_back(cci);
	cci.name = "Suberung";
	m_ConfPageInfo.push_back(cci);
	cci.name = "XML";
	m_ConfPageInfo.push_back(cci);
	cci.name = "Encodierung";
	m_ConfPageInfo.push_back(cci);
	cci.name = "Layout";
	m_ConfPageInfo.push_back(cci);
	cci.name = "Operation";
	m_ConfPageInfo.push_back(cci);
}

BOOL CConfigDlg::IsDialogMsg(LPMSG lpMsg)
{
	if (m_ConfPageInfo[m_nCurrConfPage].pConfigPage &&
		::IsDialogMessage(m_ConfPageInfo[m_nCurrConfPage].pConfigPage->GetWindow()->m_hWnd,
							lpMsg))
		return TRUE;
	return IsDialogMessage(lpMsg);
}

//-------------------------------------------------------------------
LRESULT CConfigDlg::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	// Set HTML Tidy's icon
	HICON hicon = LoadIcon(_Module.GetModuleInstance(),
		MAKEINTRESOURCE(IDI_TIDY));
	SetIcon(hicon);

	// Initialize tab control
	m_TabCtrl.Attach(GetDlgItem(IDC_CONFIG_TAB));
	int i = 0;
	for (ConfPageInfoColl::const_iterator it = m_ConfPageInfo.begin();
			it != m_ConfPageInfo.end(); ++it) {
		TCITEM ti;
		ti.mask = TCIF_TEXT;
		ti.pszText = const_cast<char*>(it->name.c_str());
		m_TabCtrl.InsertItem(i++, &ti);
	}

	m_nCurrConfPage = 0;
	ShowConfigPage(m_nCurrConfPage);

	return 1;
}

LRESULT CConfigDlg::OnDestroy(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	for (ConfPageInfoColl::const_iterator it = m_ConfPageInfo.begin();
			it != m_ConfPageInfo.end(); ++it) {
		if (it->pConfigPage)
			it->pConfigPage->Terminate();
	}

	return 0;
}

//-------------------------------------------------------------------
LRESULT CConfigDlg::OnApply(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	ApplySettings();
	UpdateSettings();
	return 0;
}

void CConfigDlg::ApplySettings()
{
	ConfPageInfoColl::const_iterator it;
	for (it = m_ConfPageInfo.begin();
		it != m_ConfPageInfo.end(); ++it) {
		if (it->pConfigPage) {
			it->pConfigPage->Validate();
		}
	}

	m_pTidyProxy->AdjustConfig();
}

void CConfigDlg::UpdateSettings()
{
	ConfPageInfoColl::const_iterator it;
	for (it = m_ConfPageInfo.begin();
		it != m_ConfPageInfo.end(); ++it) {
		if (it->pConfigPage) {
			it->pConfigPage->Update();
		}
	}
}

LRESULT CConfigDlg::OnLoadConfig(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	OPENFILENAME ofn;       // common dialog box structure
	char fileName[_MAX_PATH];
	string prevFileName = GetProfileString(CONFIG_FILE_REG_KEY);
	if (prevFileName.length() > 0)
		strcpy(fileName, prevFileName.c_str());
	else fileName[0] = '\0';

	// Initialize OPENFILENAME
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = m_hWnd;
	ofn.lpstrFile = fileName;
	ofn.nMaxFile = sizeof(fileName);
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	// Display the Open dialog box
	if (GetOpenFileName(&ofn) == TRUE) {
		m_pTidyProxy->LoadConfig(fileName);
		for (ConfPageInfoColl::const_iterator it = m_ConfPageInfo.begin();
				it != m_ConfPageInfo.end(); ++it) {
			if (it->pConfigPage)
				it->pConfigPage->Update();
		}
		WriteProfileString(CONFIG_FILE_REG_KEY, fileName);
	}

	return 0;
}

LRESULT CConfigDlg::OnSaveAs(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	OPENFILENAME ofn;       // common dialog box structure
	char fileName[_MAX_PATH];
	string prevFileName = GetProfileString(CONFIG_FILE_REG_KEY);
	if (prevFileName.length() > 0)
		strcpy(fileName, prevFileName.c_str());
	else fileName[0] = '\0';

	// Initialize OPENFILENAME
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = m_hWnd;
	ofn.lpstrFile = fileName;
	ofn.nMaxFile = sizeof(fileName);
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_NOREADONLYRETURN | OFN_OVERWRITEPROMPT;

	// Display the Save as dialog box
	if (GetSaveFileName(&ofn) == TRUE) {
		ofstream ofs(fileName);
		ApplySettings();
		UpdateSettings();
		m_pTidyProxy->SaveConfig(ofs);
		WriteProfileString(CONFIG_FILE_REG_KEY, fileName);
	}

	return 0;
}

LRESULT CConfigDlg::OnCopyConfig(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	ApplySettings();
	UpdateSettings();
	m_pTidyProxy->CopyConfig();
	return 0;
}


LRESULT CConfigDlg::OnResetConfig(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	int res = MessageBox("Wollen Sie wirklich ALLE Konfigurations-\n"
			   "Optionen auf Standardwerte zurcksetzen?",
		"Tidy Konfiguration zurcksetzen", MB_OKCANCEL | MB_DEFBUTTON2 | MB_ICONWARNING);
	if (res == IDOK) {
		m_pTidyProxy->ResetConfig();
		for (ConfPageInfoColl::const_iterator it = m_ConfPageInfo.begin();
			it != m_ConfPageInfo.end(); ++it) {
			if (it->pConfigPage)
				it->pConfigPage->Update();
		}
	}

	return 0;
}


LRESULT CConfigDlg::OnCancel(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	ShowWindow(SW_HIDE);
	return 0;
}

//-------------------------------------------------------------------
LRESULT CConfigDlg::OnTabSelChange(int idCtrl, LPNMHDR pnmh, BOOL& bHandled)
{
	m_ConfPageInfo[m_nCurrConfPage].pConfigPage->GetWindow()->ShowWindow(FALSE);
	m_nCurrConfPage = m_TabCtrl.GetCurSel();
	ShowConfigPage(m_nCurrConfPage);

	return 0;
}

//-------------------------------------------------------------------
void CConfigDlg::ShowConfigPage(int n)
{
	if (m_ConfPageInfo[n].pConfigPage == NULL) {
		RECT rc;
		m_TabCtrl.GetClientRect(&rc);
		m_TabCtrl.ClientToScreen(&rc);
		ScreenToClient(&rc);
		m_TabCtrl.AdjustRect(FALSE, &rc);

		switch (n) {
		case 0:
			m_ConfPageInfo[n].pConfigPage = new CMarkupConfig; break;
		case 1:
			m_ConfPageInfo[n].pConfigPage = new CCleanupConfig; break;
		case 2:
			m_ConfPageInfo[n].pConfigPage = new CXMLConfig; break;
		case 3:
			m_ConfPageInfo[n].pConfigPage = new CEncodingConfig; break;
		case 4:
			m_ConfPageInfo[n].pConfigPage = new CLayoutConfig; break;
		case 5:
			m_ConfPageInfo[n].pConfigPage = new COperationConfig; break;
		}
		m_ConfPageInfo[n].pConfigPage->Initialize(m_hWnd, rc, m_pTidyProxy);
	}
	else m_ConfPageInfo[n].pConfigPage->GetWindow()->ShowWindow(TRUE);
}
