/*
	TidyGUI has been developped by Andr Blavier (ablavier@wanadoo.fr).
	You can use, copy, modify and distribute TidyGUI and its source code
	without fee. However:
	- The origin of TidyGUI and its source code must not be misrepresented.
	- Altered versions must be plainly marked as such and must not be
	  misrepresented as being the original source.
	- The largest part of TidyGUI is Copyright (c) 1998-2000 World Wide Web
	  Consortium (see tidy.c).
*/

// TidyGUI.cpp : Defines the entry point for the application.

#include "StdAfx.h"

#include "MainDlg.h"

// Globals
CComModule _Module;

//-------------------------------------------------------------------
int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	// Preliminaries
	_Module.Init(NULL, hInstance);
	InitCommonControls();
	if (!LoadLibrary("RICHED32.DLL")) {
		MessageBox(NULL, "TidyGUI bentigt RICHED32.DLL\nTut mir leid.",
			"TidyGUI", MB_OK | MB_ICONSTOP);
		return 1;
	}

	// Start the application's main window
	CMainDlg mainDlg(lpCmdLine);
	mainDlg.Create(NULL);
	mainDlg.ShowWindow(nCmdShow);

	// Pump messages
	MSG msg;
    while (GetMessage(&msg, 0, 0, 0)) {
		/*if (!TranslateAccelerator(hwnd, haccel, &msg))*/ {
			if (!mainDlg.IsDialogMsg(&msg)) {
					TranslateMessage(&msg);
					DispatchMessage(&msg);
			}
		}
	}

	// Bye
	_Module.Term();
	return 0;
}



